% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.types.R
\docType{class}
\name{dataType}
\alias{dataType}
\title{dataType R6 class.}
\format{
An \code{\link[R6]{R6Class}} generator object.
}
\description{
Inherits: \link{rdmlBaseType}.
}
\section{Initialization}{
 \preformatted{dataType$new(tar, cq = NULL, excl = NULL,
adp = NULL, mdp = NULL, endPt = NULL, bgFluor = NULL, bgFluorSlp = NULL,
quantFluor = NULL)}
}

\section{Fields}{
 \describe{
\item{\code{tar}}{\link{idReferencesType}.
  TargetID - A reference to a target.}
  \item{\code{cq}}{\link[checkmate]{checkNumber}.
  Calculated fractional PCR cycle used for downstream quantification.
  Negative values express following condition: Not Available: -1.0 }
  \item{\code{excl}}{\link[checkmate]{checkString}. Excluded. If \code{excl}
  is present, this entry should not be evaluated. Do not set this element
  to \code{FALSE} if the entry is valid. Instead, leave the entire \code{excl}
  element out instead. It may contain a string with a reason for the exclusion.
  Several reasons for exclusion should be
  seperated by semicolons ";".}
  \item{\code{adp}}{\link{adpsType}.}
  \item{\code{mdp}}{\link{mdpsType}.}
  \item{\code{endPt}}{\link[checkmate]{checkNumber}}. Value of the endpoint measurement.
  \item{\code{bgFluor}}{\link[checkmate]{checkNumber}. Background
  fluorescence (the y-intercept of the baseline trend based on the estimated
  background fluorescence). }
  \item{\code{bgFluorSlp}}{\link[checkmate]{checkNumber}.
  Background fluorescence slope - The slope of the baseline trend based on
  the estimated background fluorescence. The element should be absent to
  indicate a slope of 0.0; If this element is present without the \code{bgFluor}
  element it should be ignored. }
  \item{\code{quantFluor}}{\link[checkmate]{checkNumber}. Quantification flourescence -
  The fluorescence value corresponding to the treshold line.} }
}

\section{Methods}{
 \describe{
\item{\code{AsDataFrame(dp.type = "adp")}}{Represents amplification
(\preformatted{dp.type = "adp"}) or melting (\code{dp.type = "mdp"}) data
points as \code{data.frame}}
}
}

\section{Super class}{
\code{\link[RDML:rdmlBaseType]{RDML::rdmlBaseType}} -> \code{dataType}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-dataType-new}{\code{dataType$new()}}
\item \href{#method-dataType-GetFData}{\code{dataType$GetFData()}}
\item \href{#method-dataType-clone}{\code{dataType$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id=".asXMLnodes"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-.asXMLnodes'><code>RDML::rdmlBaseType$.asXMLnodes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="copy"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-copy'><code>RDML::rdmlBaseType$copy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="print"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-print'><code>RDML::rdmlBaseType$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataType-new"></a>}}
\if{latex}{\out{\hypertarget{method-dataType-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataType$new(
  tar,
  cq = NULL,
  excl = NULL,
  adp = NULL,
  mdp = NULL,
  endPt = NULL,
  bgFluor = NULL,
  bgFluorSlp = NULL,
  quantFluor = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataType-GetFData"></a>}}
\if{latex}{\out{\hypertarget{method-dataType-GetFData}{}}}
\subsection{Method \code{GetFData()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataType$GetFData(dp.type = "adp")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dataType-clone"></a>}}
\if{latex}{\out{\hypertarget{method-dataType-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dataType$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
