% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkerboardMass.R
\name{checkerboardDensityIndex}
\alias{checkerboardDensityIndex}
\title{Estimate a single entry of the checkerboard mass density}
\usage{
checkerboardDensityIndex(X, Y, k, l, resolution1, resolution2)
}
\arguments{
\item{X}{First coordinate of the observations.}

\item{Y}{Second coordinate of the observations.}

\item{k}{Index of the first component.}

\item{l}{Index of the second component.}

\item{resolution1}{A natural number specifying the resolution of the first component.}

\item{resolution2}{A natural number specifying the resolution of the second component.}
}
\value{
The estimated checkerboard mass density \eqn{A_{kl}}.
}
\description{
Estimate the value \eqn{A_{kl}} of the non-square checkerboard mass density.
}
\details{
This implementation modifies the code of build_checkerboard_weights() published in 'qad', version 1.0.4, available at \href{https://CRAN.R-project.org/package=qad}{https://CRAN.R-project.org/package=qad},
to allow for the evaluation of a single index of the non-square checkerboard mass densities.
For more details on the implementation see \code{\link[qad]{ECBC}} and for more information on the implemented changes, see the file 'src/code.cpp'.
}
\examples{
U <- runif(20)
V <- runif(20)
checkerboardDensity(U, V, 3, 3)
checkerboardDensityIndex(U, V, 1, 2, 3, 3)
}
