% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicate-weights.R
\name{hcg.replicate.weights}
\alias{hcg.replicate.weights}
\title{HCG parametric bootstrap replicate weights}
\usage{
hcg.replicate.weights(
  rds.data,
  outcome.variable,
  number.of.bootstrap.samples = 500,
  include.sample.weights = FALSE,
  N = NULL,
  small.fraction = FALSE
)
}
\arguments{
\item{rds.data}{An rds.data.frame}

\item{outcome.variable}{The column name of the variable defining the groups for the homophily configuration graph}

\item{number.of.bootstrap.samples}{The number of bootstrap replicate weights to be generated}

\item{include.sample.weights}{If TRUE, the first column of the returned frame are the HCG weights for the sample}

\item{N}{The population size}

\item{small.fraction}{If TRUE, the sample size is assumed to be small compared to the population size}
}
\value{
A data.frame of replicate weights. If include.sample.weights is TRUE, the
first column are the HCG weights for the observed sample.
}
\description{
HCG parametric bootstrap replicate weights
}
\details{
This function generates bootstrap replicate weights which may be used to
analyze RDS data in other packages or software systems (e.g. the survey package
with svrepdesign).
}
\examples{
\dontrun{
data("fauxmadrona")
set.seed(1)
# Generate replicate weights
result <- hcg.replicate.weights(fauxmadrona, "disease", 50, TRUE)
# Analyze with survey package and compare to internal function
if(require(survey)){
  set.seed(1)
  design <- svrepdesign(fauxmadrona, type = "bootstrap", 
    weights= result[[1]], repweights = result[-1])
  svymean(~disease, design) |> print()
  RDS.bootstrap.intervals(fauxmadrona, "disease", "HCG", "HCG", 
  number.of.bootstrap.samples = 50) |> print()
}
}
}

