% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_funcs.R
\name{key_actions}
\alias{key_actions}
\title{This function makes the key accessible to all functions.}
\usage{
key_actions(action = c("register_key", "get_key", "delete_key"),
  value = NULL)
}
\arguments{
\item{action}{Which action to perform. Check the details.}

\item{value}{The steam key to use. It is used only in the \code{register_key} action. If you
do not have a key, you can get one at \url{https://steamcommunity.com/dev}.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
\code{key_actions} will allow the user to register (set), get (retrieve) or delete the key.
}
\details{
There are three actions that can be performed in this function:
\itemize{
  \item \strong{register_key} This action sets the key and at the same time makes it available
                              to all the other functions. The key argument in the api calls
                              (i.e. functions) should not be used after setting the key with
                              \code{key_actions}. It is good practice to store the key in an
                              environment variable in .Renviron and then use \code{Sys.getenv()}
                              to retrieve it. This technique is described in detail in
                              \url{https://github.com/LyzandeR/RDota2} in the readme file.
  \item \strong{get_key} Returns the current key.
  \item \strong{delete_key} Deletes the key.
}
}
\examples{
\dontrun{
key_actions(action = 'register_key', value = Sys.getenv('RDota_KEY'))
key_actions(action = 'register_key', value = 'xxxxxxxxxxxxx')
key_actions(action = 'get_key')
key_actions(action = 'delete_key')
}

}

