% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dense_matrix_kernels.R
\name{CholeskyMicrobenchmark}
\alias{CholeskyMicrobenchmark}
\title{Conducts a single performance trial with the Cholesky factorization dense
matrix kernel}
\usage{
CholeskyMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{DenseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the dense matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the dense matrix kernel}
}
\value{
a vector containing the user, system, and elapsed performance
  timings in that order
}
\description{
\code{CholeskyMicrobenchmark} conducts a single performance trial of the
Cholesky factorization dense matrix kernel for the matrix given in the
\code{kernelParameters} parameter.  The function times the single function
call \code{chol(kernelParameters$A)}.
}
\examples{
\dontrun{
# Allocate input to the Cholesky microbenchmark for the first matrix size
# to be tested
microbenchmarks <- GetDenseMatrixDefaultMicrobenchmarks()
kernelParameters <- CholeskyAllocator(microbenchmarks[["cholesky"]], 1)
# Execute the microbenchmark
timings <- CholeskyMicrobenchmark(microbenchmarks[["cholesky"]], kernelParameters)
}

}
