% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning_kernels.R
\name{ClaraClusteringMicrobenchmark}
\alias{ClaraClusteringMicrobenchmark}
\title{Conducts a single performance trial with the cluster::clara function}
\usage{
ClaraClusteringMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{ClusteringMicrobenchmark}} specifying various parameters
for microbenchmarking the cluster::clara function}

\item{kernelParameters}{a list of data objects to be used as input to
the clustering function}
}
\value{
a vector containing the user, system, and elapsed performance
  timings in that order
}
\description{
\code{ClusteringMicrobenchmark} conducts a single performance trial
of the cluster::clara function with the data given in the
\code{kernelParameters} parameter.
}
\examples{
\dontrun{
# Allocate input to the pam clustering microbenchmark
microbenchmarks <- GetClusteringExampleMicrobenchmarks()
kernelParameters <- ClusteringAllocator(microbenchmarks[["clara_cluster_3_3_1000"]])
# Execute the microbenchmark
timings <- ClaraClusteringMicrobenchmark(
   microbenchmarks[["clara_cluster_3_3_1000"]], kernelParameters)
}

}
