% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning_benchmark.R
\name{PerformClusteringMicrobenchmarking}
\alias{PerformClusteringMicrobenchmarking}
\title{Performs microbenchmarking of machine learning functions specified by an
input list}
\usage{
PerformClusteringMicrobenchmarking(microbenchmarks, microbenchmarkingFunction,
  numberOfThreads, runIdentifier, resultsDirectory)
}
\arguments{
\item{microbenchmarks}{a list of
\code{ClusteringMicrobenchmark} objects defining the machine learning
microbenchmarks to be executed as part of the machine learning
benchmark.}

\item{microbenchmarkingFunction}{a function that performs the run time
performance trials, computes the summary performance statistics, and
writes the performance results to standard out,}

\item{numberOfThreads}{the number of threads the microbenchmarks are
intended to be executed with; the value is for display purposes only as
the number of threads used is assumed to be controlled through environment
variables}

\item{runIdentifier}{a character string specifying the suffix to be
appended to the base of the file name of the output CSV format files}

\item{resultsDirectory}{a character string specifying the directory
where all of the CSV performance results files will be saved}
}
\value{
a data frame containing the benchmark name, user, system, and elapsed
  (wall clock) times of each performance trial each microbenchmark
}
\description{
\code{PerformClusteringMicrobenchmarking} performs microbenchmarking
of machine learning functionality specified by the input list of
\code{ClusteringMicrobenchmark} objects.  Objects with the \code{active}
flag set to TRUE indicate that the corresponding microbenchmark will be
performed; FALSE indicates that the microbenchmark will be skipped.
}
