% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarking_utils.R
\name{PrintClusteringMicrobenchmarkResults}
\alias{PrintClusteringMicrobenchmarkResults}
\title{Prints results of a clustering for machine learning microbenchmark}
\usage{
PrintClusteringMicrobenchmarkResults(benchmarkName, numberOfThreads,
  numberOfFeatures, numberOfFeatureVectors, numberOfClusters,
  numberOfSuccessfulTrials, trialTimes, averageWallClockTimes,
  standardDeviations)
}
\arguments{
\item{benchmarkName}{character string specifying the name of the
microbenchmark}

\item{numberOfThreads}{the number of threads all of the performance trials
were conducted with}

\item{numberOfFeatures}{the number of features, i.e. the dimension of the
feature vector}

\item{numberOfFeatureVectors}{the number of feature vectors in the data set}

\item{numberOfClusters}{the number of clusters in the data set}

\item{numberOfSuccessfulTrials}{an integer vector specifying the number of
performance trials that were successfully performed for each data set}

\item{trialTimes}{a real matrix with each column containing the run times
of all of the successful performance trials associated with a particular
data set.  The number of valid entries in each column are specified by the
entries in the \code{numberOfSuccessfulTrials} vector}

\item{averageWallClockTimes}{a vector of average wall clock times computed
for each matrix tested during the performance trials}

\item{standardDeviations}{a vector of standard deviations of the wall clock
times obtained for each matrix tested during the performance trials}
}
\description{
\code{PrintClusteringMicrobenchmarkResults} prints performance results
for a clustering for machine learning microbenchmark to standard output in a
format that is easily human readable
}
\details{
This function prints the performance results obtained by a clustering for
machine learning microbenchmark.  Summary run time performance statistics for
each clustering data set tested are computed and printed.  The summary
statistics include the minimum, maximum, average, and standard deviation of
the wall clock times obtained by the performance trials with respect to each
data tested.
}
