% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_matrix_kernels.R
\name{SparseMatrixVectorMicrobenchmark}
\alias{SparseMatrixVectorMicrobenchmark}
\title{Conducts a single performance trial with the matrix-vector multiplication
sparse matrix kernel}
\usage{
SparseMatrixVectorMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{SparseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the sparse matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the sparse matrix kernel}
}
\value{
a vector containing the user, system, and elapsed performance
  timings in that order
}
\description{
\code{SparseMatrixVectorMicrobenchmark} conducts a single performance trial
of the matrix-vector multiplication sparse matrix kernel for the matrix given
in the \code{kernelParameters} parameter.  The function times the single
function call \code{kernelParameters$A \%*\% kernelParameters$b}.
}
\examples{
\dontrun{
# Allocate input to the matrix-vector microbenchmark for the first Laplacian
# matrix
microbenchmarks <- GetSparseMatrixVectorDefaultMicrobenchmarks()
kernelParameters <- SparseMatrixVectorAllocator(
   microbenchmarks[["matvec_laplacian7pt_100"]], 1)
# Execute the microbenchmark
timings <- SparseMatrixVectorMicrobenchmark(
   microbenchmarks[["matvec_laplacian7pt_100"]], kernelParameters)
}

}
