% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avHRT.R
\docType{class}
\name{avHRT}
\alias{avHRT}
\alias{initialize,avHRT-method}
\title{S4 class to represent an avHRT object}
\usage{
\S4method{initialize}{avHRT}(
  .Object,
  av = mean,
  orTO = "avAfter",
  orTS = "avBefore",
  pTO = NA_real_,
  pTS = NA_real_,
  pTT = NA_real_,
  pnTS = NA_real_,
  nRMSSD = NA_real_,
  couplRR = NA_real_,
  compRR = NA_real_,
  preRRs = NA_real_,
  postRRs = NA_real_
)
}
\arguments{
\item{.Object}{The name of the class}

\item{av}{(Function) Type of averaging, either mean or median}

\item{orTO}{(Character) Order in which TO was calculated,
either "avAfter" (assessment of parameter and averaging)
or "avBefore" (averaging of the VPCSs and assessment of parameter)}

\item{orTS}{(Character) Order in which TS was calculated,
either "avAfter" (assessment of parameter and averaging)
or "avBefore" (averaging of the VPCSs and assessment of parameter)}

\item{pTO}{(Numeric) p-value of t-test checking the validity of TO}

\item{pTS}{(Numeric) p-value of t-test checking the validity of TS}

\item{pTT}{(Numeric) p-value of t-test checking the validity of TT}

\item{pnTS}{(Numeric) p-value of t-test checking the validity of normalised TS}

\item{nRMSSD}{(Numeric) RMSSD normalised to HR}

\item{couplRR}{(Numeric) Coupling interval}

\item{compRR}{(Numeric) Compensatory interval}

\item{preRRs}{(Numeric vector) Preceding intervals}

\item{postRRs}{(Numeric vector) Following intervals}
}
\value{
(avHRT) A new avHRT object
}
\description{
This class extends the HRT class. An avHRT is the average of an HRTList and
saves the way in which it was calculated.
}
\section{Slots}{

\describe{
\item{\code{av}}{(Function) Type of averaging, either mean or median}

\item{\code{orTO}}{(Character) Order in which TO was calculated,
either "avAfter" (assessment of parameter and averaging)
or "avBefore" (averaging of the VPCSs and assessment of parameter)}

\item{\code{orTS}}{(Character) Order in which TS was calculated,
either "avAfter" (assessment of parameter and averaging)
or "avBefore" (averaging of the VPCSs and assessment of parameter)}

\item{\code{pTO}}{(Numeric) p-value of t-test checking the validity of TO}

\item{\code{pTS}}{(Numeric) p-value of t-test checking the validity of TS}

\item{\code{pTT}}{(Numeric) p-value of t-test checking the validity of TT}

\item{\code{pnTS}}{(Numeric) p-value of t-test checking the validity of normalised TS}
}}

