% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractTimeSegment.R
\name{Window}
\alias{Window}
\title{Time windows of RR intervals}
\usage{
Window(HRVData, start, end)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information 
related to it.}

\item{start}{The start time of the period of interest.}

\item{end}{The end time of the period of interest.}
}
\value{
A new \emph{HRVData} structure containing the subset of RR intervals
within the specified range.
}
\description{
Extracts a temporal subset between the times start and end.
}
\details{
If the \emph{HRVData} episodes, beats or RR time series,
these will be also extracted into the new HRV structure. On the other hand,
all the analysis stored in the original structure will be lost.
}
\examples{
\dontrun{
data(HRVProcessedData)
# Rename for convenience
HRVData <- HRVProcessedData
PlotNIHR(HRVData)
newHRVData <- Window(HRVData,2000,4000)
PlotNIHR(newHRVData)
}
}
