/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.Days;
import ec.tstoolkit.timeseries.GeneralTsData;
import java.util.Date;

public class DailyCollector {
    private int[] m_ids;
    private double[] m_vals;
    private int m_n;
    private static final int g_blocksize = 512;

    public boolean add(Date date, double val) {
        return this.add(new Day(date), val);
    }

    public boolean add(Day day, double val) {
        int id = day.getId();
        if (this.m_n > 0 && this.m_ids[this.m_n - 1] >= id) {
            return false;
        }
        if (this.m_ids == null || this.m_ids.length == this.m_n) {
            this.do_extends();
        }
        this.m_ids[this.m_n] = id;
        this.m_vals[this.m_n] = val;
        ++this.m_n;
        return true;
    }

    public void clear() {
        this.m_n = 0;
    }

    public Day day(int idx) {
        return new Day(this.m_ids[idx]);
    }

    private void do_extends() {
        if (this.m_ids == null) {
            this.m_ids = new int[512];
            this.m_vals = new double[512];
        } else {
            int[] ids = new int[this.m_ids.length + 512];
            double[] vals = new double[this.m_vals.length + 512];
            System.arraycopy(this.m_ids, 0, ids, 0, this.m_ids.length);
            System.arraycopy(this.m_vals, 0, vals, 0, this.m_vals.length);
            this.m_ids = ids;
            this.m_vals = vals;
        }
    }

    public int getSize() {
        return this.m_n;
    }

    public GeneralTsData makeSeries() {
        if (this.m_n == 0) {
            return null;
        }
        Days days = new Days(this.m_ids, 0, this.m_n);
        GeneralTsData ts = new GeneralTsData(days);
        for (int i = 0; i < this.m_n; ++i) {
            ts.set(i, this.m_vals[i]);
        }
        return ts;
    }

    public double value(int idx) {
        return idx >= this.m_n ? Double.NaN : this.m_vals[idx];
    }
}

