% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_SEQ2R.R
\name{read_SEQ2R}
\alias{read_SEQ2R}
\title{Parse a Risø SEQ-file to a sequence necessary for simulating quartz luminescence}
\usage{
read_SEQ2R(file, lab.dose_rate = 1, txtProgressBar = TRUE)
}
\arguments{
\item{file}{\link{character} (\strong{required}): a *.seq file created by the Risø Sequence Editor}

\item{lab.dose_rate}{\link{character} (with default): set the dose rate of the radiation source
in the laboratory Gy/s. Default: 1 Gy/s}

\item{txtProgressBar}{\link{logical} (with default): enables or disables the \code{txtProgressBar} for a visual
control of the progress. Default: \code{txtProgressBar = TRUE}}
}
\value{
This function returns a \link{list} with the parsed *.seq file and the required steps for
\link{model_LuminescenceSignals}.
}
\description{
A SEQ-file created by the Risø Sequence Editor can be imported to simulate the sequence written
in the sequence editor.
}
\details{
\strong{Supported versions}: Supported and tested: version 4.36.
}
\section{Function version}{
 0.1.1
}

\examples{
##search "example_SAR_cycle.SEQ" in "extdata" in package "RLumModel"
path <- system.file("extdata", "example_SAR_cycle.SEQ", package="RLumModel")

sequence <- read_SEQ2R(file = path, txtProgressBar = FALSE)

} 

\section{How to cite}{
Friedrich, J., 2025. read_SEQ2R(): Parse a Risø SEQ-file to a sequence necessary for simulating quartz luminescence. Function version 0.1.1. In: Friedrich, J., Kreutzer, S., Schmidt, C., 2025. RLumModel: Solving Ordinary Differential Equations to Understand Luminescence. R package version 0.2.11. https://CRAN.R-project.org/package=RLumModel
}

\references{
Riso: Sequence Editor User Manual.
Available at: http://www.nutech.dtu.dk/english/-/media/Andre_Universitetsenheder/Nutech/Produkter
\%20og\%20services/Dosimetri/radiation_measurement_instruments/tl_osl_reader/Manuals/
SequenceEditor.ashx?la=da
}
\seealso{
\link{model_LuminescenceSignals}, \link{readLines}
}
\author{
Johannes Friedrich, University of Bayreuth (Germany),
}
