% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELECTRE.R
\name{apply.ELECTRE1}
\alias{apply.ELECTRE1}
\title{Apply ELECTRE I method}
\usage{
apply.ELECTRE1(mat, weights)
}
\arguments{
\item{mat}{A matrix or data frame where rows represent alternatives and columns represent criteria.}

\item{weights}{A numeric vector of weights for each criterion.}
}
\value{
a list containing three matrices, the first one is the intersection of concordance and discordance
matrices, the second one is the concordance matrix, and the third one is the discordance matrix.
}
\description{
Apply ELECTRE I method
}
\examples{
mat <- matrix(c(25, 10, 30, 20, 30, 10, 15, 20, 30, 30, 30, 10), nrow=3)
colnames(mat)<-c("c1", "c2", "c3", "c4")
rownames(mat)<-c("a1", "a2", "a3")
weights <- c(0.2, 0.15, 0.4, 0.25)

# Apply ELECTRE I method
results <- apply.ELECTRE1(mat, weights)

}
