% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cos.R
\name{StackForPlot}
\alias{StackForPlot}
\title{Rearrange the data from \code{LogErrorCosPdf} for plot}
\usage{
StackForPlot(error, a, b, N)
}
\arguments{
\item{error}{return of \code{LogErrorCosPdf}}

\item{a}{the lower limit of the truncation interval}

\item{b}{the upper limit of the truncation interval}

\item{N}{the number of cos term for summation}
}
\value{
Suitable tibble data for plot by group in ggplot
}
\description{
Rearrange the data from \code{LogErrorCosPdf} for plot
}
\examples{
N <- c(1:200)
L <- c(10, 20, 60, 100, 1000)
a <- -L / 2
b <- L / 2
x <- seq(-5, 5, by = 10 / (32 - 1))
el <- LogErrorCosPdf(x, dnorm, NormChf, a, b, N)
StackForPlot(el, a, b, N)
}
