% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OINT.R
\name{OINT}
\alias{OINT}
\title{Omnibus-INT}
\usage{
OINT(
  y,
  G,
  X = NULL,
  k = 0.375,
  ties.method = "average",
  weights = c(1, 1),
  simple = FALSE
)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Genotype matrix with observations as rows, SNPs as columns.}

\item{X}{Model matrix of covariates and structure adjustments. Should include
an intercept. Omit to perform marginal tests of association.}

\item{k}{Offset applied during rank-normalization. See
\code{\link{RankNorm}}.}

\item{ties.method}{Method of breaking ties, passed to \code{base::rank}.}

\item{weights}{Respective weights to allocate the DINT and IINT tests.}

\item{simple}{Return the OINT p-values only?}
}
\value{
A numeric matrix of p-values, three for each column of \code{G}.
}
\description{
Association test that synthesizes the \code{\link{DINT}} and
\code{\link{IINT}} tests. The first approach is most powerful for traits that
could have arisen from a rank-preserving transformation of a latent normal
trait. The second approach is most powerful for traits that are linear in
covariates, yet have skewed or kurtotic residual distributions. During the
omnibus test, the direct and indirect tests are separately applied, then the
p-values are combined via the Cauchy combination method.
}
\examples{
set.seed(100)
# Design matrix
X <- cbind(1, rnorm(1e3))
# Genotypes
G <- replicate(1e3, rbinom(n = 1e3, size = 2, prob = 0.25))
storage.mode(G) <- "numeric"
# Phenotype
y <- exp(as.numeric(X \%*\% c(1, 1)) + rnorm(1e3))
# Omnibus
p <- OINT(y = y, G = G, X = X, simple = TRUE)
}
\seealso{
\itemize{
  \item Basic association test \code{\link{BAT}}.
  \item Direct INT test \code{\link{DINT}}.
  \item Indirect INT test \code{\link{IINT}}.
}
}
