% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtm_functions.r
\name{term_day_dist}
\alias{term_day_dist}
\title{Calculate statistics for term occurence across days}
\usage{
term_day_dist(dtm, meta = NULL, date.var = "date")
}
\arguments{
\item{dtm}{A quanteda \link[quanteda]{dfm}. Alternatively, a DocumentTermMatrix from the tm package can be used, but then the meta parameter needs to be specified manually}

\item{meta}{If dtm is a quanteda dfm, docvars(meta) is used by default (meta is NULL) to obtain the meta data. Otherwise, the meta data.frame has to be given by the user, with the rows of the meta data.frame matching the rows of the dtm (i.e. each row is a document)}

\item{date.var}{The name of the meta column specifying the document date. default is "date". The values should be of type POSIXlt or POSIXct}
}
\value{
A data.frame with statistics for each term.
}
\description{
Calculate statistics for term occurence across days
}
\examples{
tdd = term_day_dist(rnewsflow_dfm, date.var='date')
head(tdd)
tail(tdd)
}
