% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpygeo.R
\docType{package}
\name{RPyGeo-package}
\alias{RPyGeo}
\alias{RPyGeo-package}
\title{RPyGeo: ArcGIS Geoprocessing in R via Python}
\description{
Provide access to (virtually any) ArcGIS geoprocessing tool from
  within R by running Python
  geoprocessing without writing Python code or touching ArcGIS.
}
\details{
The package utilizes the ArcPy Python site-package or the ArcGIS API
  in order to access ArcGIS functionality. The function
  \code{\link{rpygeo_build_env}} can be applied to generate an ArcPy or arcgis
  object.
}
\examples{

# load the ArcPy module related to ArcGIS Pro (and save it as a R
# object called "arcpy_m") in R and also set the overwrite parameter
# to FALSE and add some extensions. Note that we do not have to set the path
# because the Python version is located in the default location
# (C:/Program Files/ArcGIS/Pro/bin/Python/envs/arcgispro-py3/)in this example.
\dontrun{arcpy <- rpygeo_build_env(overwrite = TRUE,
                                     extensions = c("3d", "Spatial", "na"),
                                     pro = TRUE)}
# Suppose we want to calculate the slope of a Digtial Elevation Model.
# It is possible to get the description of any ArcPy function as a R list:
\dontrun{py_function_docs("arcpy$Slope_3d")}
# Now we can run our computation:
\dontrun{arcpy$Slope_3d(arcpy$Slope_3d(in_raster = "dem.tif", out_raster = "slope.tif")}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/fapola/RPyGeo}
  \item Report bugs at \url{https://github.com/fapola/RPyGeo/issues}
}

}
\author{
\strong{Maintainer}: Alexander Brenning \email{alexander.brenning@uni-jena.de}

Authors:
\itemize{
  \item Fabian Polakowski \email{fabian.polakowski@gmail.com}
  \item Marc Becker \email{marc.becker@uni-jena.de}
}

Other contributors:
\itemize{
  \item Jannes Muenchow (0000-0001-7834-4717) [contributor]
}

}
