% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boost.R
\name{Boost.validation}
\alias{Boost.validation}
\title{Robust Boosting for regression with initialization parameters chosen on a validation set}
\usage{
Boost.validation(
  x_train,
  y_train,
  x_val,
  y_val,
  x_test,
  y_test,
  type = "RRBoost",
  error = c("rmse", "aad"),
  niter = 1000,
  max_depth = 1,
  y_init = "LADTree",
  max_depth_init_set = c(1, 2, 3, 4),
  min_leaf_size_init_set = c(10, 20, 30),
  control = Boost.control()
)
}
\arguments{
\item{x_train}{predictor matrix for training data (matrix/dataframe)}

\item{y_train}{response vector for training data (vector/dataframe)}

\item{x_val}{predictor matrix for validation data (matrix/dataframe)}

\item{y_val}{response vector for validation data (vector/dataframe)}

\item{x_test}{predictor matrix for test data (matrix/dataframe, optional, required when \code{make_prediction} in control is \code{TRUE})}

\item{y_test}{response vector for test data (vector/dataframe,  optional, required when \code{make_prediction} in control is \code{TRUE})}

\item{type}{type of the boosting method: "L2Boost", "LADBoost", "MBoost", "Robloss", "SBoost", "RRBoost" (character string)}

\item{error}{a character string (or vector of character strings) indicating the types of error metrics to be evaluated on the test set. Valid options are: "rmse" (root mean squared error), "aad" (average absulute deviation), and "trmse" (trimmed root mean squared error)}

\item{niter}{number of iterations (for RRBoost \eqn{T_{1,max} + T_{2,max}}) (numeric)}

\item{max_depth}{the maximum depth of the tree learners (numeric)}

\item{y_init}{a string indicating the initial estimator to be used. Valid options are: "median" or "LADTree" (character string)}

\item{max_depth_init_set}{a vector of possible values of the maximum depth of the initial LADTree that the algorithm choses from}

\item{min_leaf_size_init_set}{a vector of possible values of the minimum observations per node of the initial LADTree that the algorithm choses from}

\item{control}{a named list of control parameters, as returned by \code{\link{Boost.control}}}
}
\value{
A list with components
\item{the components of model}{an object returned by Boost that is trained with selected initialization parameters}
\item{param}{a vector of selected initialization parameters (return (0,0) if selected initialization is the median of the training responses)}
}
\description{
A function to fit RRBoost (see also \code{\link{Boost}}) where the initialization parameters are chosen
based on the performance on the validation set.
}
\details{
This function runs the RRBoost algorithm (see \code{\link{Boost}}) on different combinations of the
parameters for the initial fit, and chooses the optimal set based on the performance on the validation set.
}
\examples{
\dontrun{
data(airfoil)
n <- nrow(airfoil)
n0 <- floor( 0.2 * n )
set.seed(123)
idx_test <- sample(n, n0)
idx_train <- sample((1:n)[-idx_test], floor( 0.6 * n ) )
idx_val <- (1:n)[ -c(idx_test, idx_train) ]
xx <- airfoil[, -6]
yy <- airfoil$y
xtrain <- xx[ idx_train, ]
ytrain <- yy[ idx_train ]
xval <- xx[ idx_val, ]
yval <- yy[ idx_val ]
xtest <- xx[ idx_test, ]
ytest <- yy[ idx_test ]
model_RRBoost_cv_LADTree = Boost.validation(x_train = xtrain,
      y_train = ytrain, x_val = xval, y_val = yval,
      x_test = xtest, y_test = ytest, type = "RRBoost", error = "rmse",
      y_init = "LADTree", max_depth = 1, niter = 1000,
      max_depth_init_set = 1:5,
      min_leaf_size_init_set = c(10,20,30),
      control = Boost.control(make_prediction =  TRUE,
      cal_imp = TRUE))
}

}
\seealso{
\code{\link{Boost}}, \code{\link{Boost.control}}.
}
\author{
Xiaomeng Ju, \email{xiaomeng.ju@stat.ubc.ca}
}
