% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate.map.R
\name{rate.map}
\alias{rate.map}
\title{Mapping rate and direction of phenotypic change on 3D surfaces.}
\usage{
rate.map(x, RR, PCscores, pcs, mshape, out.rem = TRUE,
  shape.diff=FALSE, show.names=TRUE)
}
\arguments{
\item{x}{the species/nodes to be compared; it can be a single species, or a
vector containing two species or a species and any of its parental nodes.}

\item{RR}{an object generated by using the \code{\link{RRphylo}} function}

\item{PCscores}{PC scores.}

\item{pcs}{RW (or PC) vectors (eigenvectors of the covariance matrix) of all
the samples.}

\item{mshape}{the Consensus configuration.}

\item{out.rem}{logical: if \code{TRUE} mesh triangles with outlying area
difference are removed.}

\item{shape.diff}{logical: if \code{TRUE}, the mesh area differences are
displayed in an additional 3d plot.}

\item{show.names}{logical: if \code{TRUE}, the names of the species are
displayed in the 3d plot.}
}
\value{
The function returns a list including:
  \itemize{\item\strong{$selected} a list of PCs axes selected for higher
  evolutionary rates for each species. \item\strong{$surfaces} a list of
  reconstructed coloured surfaces of the given species and of the most recent
  common ancestor.}
}
\description{
\strong{The function is deprecated, please check the new version of
  \code{rate.map} in package \pkg{RRmorph}}.

  Given vectors of RW (or PC) scores, the function selects the
  RW(PC) axes linked to highest (and lowest) evolutionary rate values and
  reconstructs the morphology weighted on them. In this way, \code{rate.map}
  shows where and how the phenotype changed the most between any pair of
  taxa.
}
\details{
After selecting the PC axes, \code{rate.map} automatically builds a
  3D mesh on the mean shape calculated from the Relative Warp Analysis (RWA)
  or Principal Component Analysis (PCA) (\cite{Schlager 2017}) by applying
  the function \code{\link[Rvcg]{vcgBallPivoting}} (\pkg{Rvcg}). Then, it
  compares the area differences between corresponding triangles of the 3D
  surfaces reconstructed for the species and surface of the mrca. Finally,
  \code{rate.map} returns a 3D plot showing such comparisons displayed on
  shape of the mrca used as the reference.The colour gradient goes from blue
  to red, where blue areas represent expansion of the mesh, while the red
  areas represent contractions of the mesh triangles. In the calculation of
  the differences of areas we supply the possibility to find and remove
  outliers from the vectors of areas calculated on the reference and target
  surfaces. We suggest considering this possibility if the mesh may contain
  degenerate facets. Additionally, \code{rate.map} allows to investigate the
  pure morphological comparison of shapes by excluding the evolutionary rate
  component by setting the argument \code{show.diff  = TRUE}. In this case, a
  second 3D plot will be displayed highlighting area differences in terms of
  expansion (green) and contraction (yellow).
}
\examples{
  \dontrun{
  data(DataSimians)
  DataSimians$pca->pcasim
  DataSimians$tree->treesim
  cc<- 2/parallel::detectCores()

  RRphylo(treesim,pcasim$PCscores,clus=cc)->RRsim

  Rmap<-rate.map(x=c("Pan_troglodytes","Gorilla_gorilla"),RR=RRsim, PCscores=pcasim$PCscores,
                 pcs=pcasim$PCs, mshape=pcasim$mshape, shape.diff = TRUE)

  }
}
\references{
Schlager, S. (2017). \emph{Morpho and Rvcg-Shape Analysis in R:
  R-Packages for geometric morphometrics, shape analysis and surface
  manipulations.} In: Statistical shape and deformation analysis. Academic
  Press.
  Castiglione, S., Melchionna, M., Profico, A., Sansalone, G.,
  Modafferi, M., Mondanaro, A., Wroe, S., Piras, P., & Raia, P. (2021). Human
  face-off: a new method for mapping evolutionary rates on three-dimensional
  digital models. Palaeontology. doi:10.1111/pala.12582
}
\seealso{
\href{../doc/RRphylo.html}{\code{RRphylo} vignette} ;
  \code{\link[Morpho]{relWarps}} ; \code{\link[Morpho]{procSym}}
}
\author{
Marina Melchionna, Antonio Profico, Silvia Castiglione, Gabriele
  Sansalone, Pasquale Raia
}
