% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridtools.R
\name{centervalue}
\alias{centervalue}
\title{Pick Center Value from Matrix}
\usage{
centervalue(x)
}
\arguments{
\item{x}{a square matrix}
}
\value{
value of the matrix entry in the middle of the matrix
}
\description{
Pick the value in the center of a square matrix. Auxiliary function to be used by functions called by \code{\link[=focal.function]{focal.function()}}.
}
\details{
See for example the code of \code{\link[=resid.median]{resid.median()}}. Intended for use with square moving window matrices with an odd number of columns and rows.
}
\examples{
( m <- matrix( round(runif(9,1,10)), ncol=3 ) )
centervalue(m)
}
\seealso{
\code{\link[=focal.function]{focal.function()}}, \code{\link[=resid.median]{resid.median()}}
}
\keyword{utilities}
