% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRReuro.R
\name{CRReuro}
\alias{CRReuro}
\title{Cox-Ross-Rubinstein binomial option model}
\usage{
CRReuro(S, X, sigma, r, T2M, N, type)
}
\arguments{
\item{S}{Stock price. \code{numeric}}

\item{X}{Strike price. \code{numeric}}

\item{sigma}{Implied volatility e.g. 0.20 \code{numeric}}

\item{r}{Risk-free rate. \code{numeric}}

\item{T2M}{Time to maturity in years \code{numeric}}

\item{N}{Number of time steps. Internally dt = T2M/N. \code{numeric}}

\item{type}{"call" or "put" \code{character}}
}
\value{
List of asset price tree, option value tree and option price. \code{list}
}
\description{
European option binomial model on a stock without dividends.For academic purpose only.
Use RTL::CRRoption for real-life usage.
}
\examples{
CRReuro(S = 100, X = 100, sigma = 0.2, r = 0.1, T2M = 1, N = 5, type = "call")
}
\author{
Philippe Cote
}
