% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_rwnn.R
\name{bag_rwnn}
\alias{bag_rwnn}
\alias{bag_rwnn.formula}
\title{Bagging random weight neural networks}
\usage{
bag_rwnn(
  formula,
  data = NULL,
  n_hidden = c(),
  lambda = NULL,
  B = 100,
  method = NULL,
  type = NULL,
  control = list()
)

\method{bag_rwnn}{formula}(
  formula,
  data = NULL,
  n_hidden = c(),
  lambda = NULL,
  B = 100,
  method = NULL,
  type = NULL,
  control = list()
)
}
\arguments{
\item{formula}{A \link{formula} specifying features and targets used to estimate the parameters of the output layer.}

\item{data}{A data-set (either a \link{data.frame} or a \link[tibble]{tibble}) used to estimate the parameters of the output layer.}

\item{n_hidden}{A vector of integers designating the number of neurons in each of the hidden layers (the length of the list is taken as the number of hidden layers).}

\item{lambda}{The penalisation constant(s) passed to either \link{rwnn} or \link{ae_rwnn} (see \code{method} argument).}

\item{B}{The number of bootstrap samples.}

\item{method}{The penalisation type passed to \link{ae_rwnn}. Set to \code{NULL} (default), \code{"l1"}, or \code{"l2"}. If \code{NULL}, \link{rwnn} is used as the base learner.}

\item{type}{A string indicating whether this is a regression or classification problem.}

\item{control}{A list of additional arguments passed to the \link{control_rwnn} function.}
}
\value{
An \link{ERWNN-object}.
}
\description{
Use bootstrap aggregation to reduce the variance of random weight neural network models.
}
\examples{
n_hidden <- 50

B <- 100
lambda <- 0.01

m <- bag_rwnn(y ~ ., data = example_data, n_hidden = n_hidden, lambda = lambda, B = B)
}
\references{
Breiman L. (1996) "Bagging Predictors." \emph{Machine Learning}, 24, 123-140.

Breiman L. (2001) "Random Forests." \emph{Machine Learning}, 45, 5-32.

Sui X, He S, Vilsen SB, Teodorescu R, Stroe DI (2021) "Fast and Robust Estimation of Lithium-ion Batteries State of Health Using Ensemble Learning." \emph{In 2021 IEEE Energy Conversion Congress and Exposition (ECCE)}, 1-8.
}
