% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_functions.R
\name{predict.ERWNN}
\alias{predict.ERWNN}
\title{Predicting targets of an ERWNN-object}
\usage{
\method{predict}{ERWNN}(object, ...)
}
\arguments{
\item{object}{An \link{ERWNN-object}.}

\item{...}{Additional arguments.}
}
\value{
An list, matrix, or vector of predicted values depended on the arguments '\code{method}', '\code{type}', and '\code{class}'.
}
\description{
Predicting targets of an ERWNN-object
}
\details{
The additional arguments '\code{newdata}', '\code{type}', and '\code{class}' can be specified as follows:
\describe{
  \item{\code{newdata}}{Expects a \link{matrix} or \link{data.frame} with the same features (columns) as in the original data.}
  \item{\code{type}}{A string taking the following values:
     \describe{
         \item{\code{"mean" (default)}}{Returns the average prediction across all ensemble models.}
         \item{\code{"std"}}{Returns the standard deviation of the predictions across all ensemble models.}
         \item{\code{"all"}}{Returns all predictions for each ensemble models.}
     }
  }
  \item{\code{class}}{A string taking the following values:
     \describe{
         \item{\code{"classify"}}{Returns the predicted class of the ensemble. If used together with \code{type = "mean"}, the average prediction across the ensemble models are used to create the classification. However, if used with \code{type = "all"}, every ensemble is classified and returned.}
         \item{\code{"voting"}}{Returns the predicted class of the ensemble by classifying each ensemble and using majority voting to make the final prediction. NB: the \code{type} argument is overruled.}
     }
  }
}

Furthermore, if '\code{class}' is set to either \code{"classify"} or \code{"voting"}, additional arguments '\code{t}' and '\code{b}' can be passed to the \link{classify}-function.

NB: if the ensemble is created using the \link{boost_rwnn}-function, then \code{type} should always be set to \code{"mean"}.
}
