% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimize.R
\name{agCohesion}
\alias{agCohesion}
\alias{srCohesion}
\alias{mapCohesion}
\title{Check map cohesion}
\usage{
agCohesion(map)

srCohesion(map)

mapCohesion(map)
}
\arguments{
\item{map}{An acmap object}
}
\value{
A scalar real value.
}
\description{
Checks the vertex connectivity of points in a map (the minimum number of
points needed to remove from the map to eliminate all paths from one point to
another point). This is for checking for example if after merging maps you
only have a small number of points in common between separate groups of
points, leading to a situation where groups of points cannot be robustly
positioned relative to each other. If the vertex connectivity is smaller than
the number of map dimensions + 1 then this will certainly be occurring and
will lead to an unstable map solution. \code{mapCohesion()} returns the minimum
vertex connectivity found between any given points, while \code{agCohesion()} and
\code{srCohesion()} return the vertex connectivity between each pair of antigens
and sera as a table helping to diagnose which antigens and sera are forming
separate groups. Note that for these purposes only detectable titers count
as connections and non-detectable titers are ignored.
}
\seealso{
Other map diagnostic functions: 
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}
}
\concept{map diagnostic functions}
