% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.radviz.R
\name{text.radviz}
\alias{text.radviz}
\title{Text annotations for for the Radviz Plots}
\usage{
\method{text}{radviz}(
  x,
  ...,
  main = NULL,
  labels = NULL,
  size = FALSE,
  label.color = NULL,
  label.size = NULL,
  adj,
  pos,
  offset,
  vfont,
  cex,
  col,
  font,
  add
)
}
\arguments{
\item{x}{a radviz object as produced by do.radviz}

\item{...}{further arguments to be passed to or from other methods (not implemented)}

\item{main}{[Optional] a title to the graph, displayed on top if add is \code{TRUE}}

\item{labels}{the name of the variable used for labeling (see details)}

\item{size}{[Logical] if \code{TRUE} labels are sized after the number of points they correspond to}

\item{label.color}{the color of springs for visualization}

\item{label.size}{the size of the anchors (see \href{https://ggplot2.tidyverse.org/articles/articles/faq-customising.html}{customizing ggplot2} for details on default value)}

\item{adj}{deprecated, see \code{\link[ggplot2]{geom_text}} instead}

\item{pos}{deprecated, see \code{\link[ggplot2]{geom_text}} instead}

\item{offset}{deprecated, see \code{\link[ggplot2]{geom_text}} instead}

\item{vfont}{deprecated, see \code{\link[ggplot2]{geom_text}} instead}

\item{cex}{deprecated, see \code{\link[ggplot2]{geom_text}} instead}

\item{col}{deprecated, see \code{\link[ggplot2]{geom_text}} instead}

\item{font}{deprecated, see \code{\link[ggplot2]{geom_text}} instead}

\item{add}{deprecated, see \code{\link[ggplot2]{geom_text}} instead}
}
\description{
Text draws the strings given in the vector labels at the coordinates given by the radviz projection
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
text(rv,labels='Species')

}
\author{
Yann Abraham
}
