% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_functions.R
\name{extendRanking}
\alias{extendRanking}
\title{Fully extend a partial ranking}
\usage{
extendRanking(umat, node)
}
\arguments{
\item{umat}{a \code{matrix}, which is either the output of \code{\link{evaluationMatrix}},
or a subset of the output of \code{\link{evaluationMatrix}}.}

\item{node}{a \code{list} of elements, containing information about a node in
the branch and bound search space. The relevant elements here are
\code{$partial.ranking}, \code{$included}, and \code{$prl}. Where,
\code{$partial.ranking} is a vector of rank positions for each \code{Item}
in \code{umat} that is ranked so far; partial rankings may contain some -
or all - \code{NA} values. \code{$included} is a logical vector denoting if
an \code{Item} in \code{umat} is ranked in \code{$partial.ranking}. And
\code{$prl} is a numeric value denoting how many of the \code{Item}s in
\code{umat} are ranked in \code{$partial.ranking}.}
}
\value{
A vector of rank positions.
}
\description{
This function is called by \code{\link{RankAggregator}}::\code{\link{consensusRanking}}.
The heuristic procedure orders unranked \code{Items} according the proportion
of times an item was preferred in all pairwise comparisons with other unranked
\code{Item}s.
}
