% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_category_strings.R
\name{get_category_strings}
\alias{get_category_strings}
\title{get_category_strings}
\usage{
get_category_strings(
  name = NULL,
  get_names = FALSE,
  start_idx = NULL,
  end_idx = NULL
)
}
\arguments{
\item{name}{A required string that is the name of the categorical variable of interest.}

\item{get_names}{An optional logical which if \code{TRUE} the function will return
a vector of categorical variable names recognized by the function.}

\item{start_idx}{An optional integer that sets the starting index of the variable's integer/label pairs.
If the value is \code{NULL}(the default), then the variable's entire integer/label pairs are returned.}

\item{end_idx}{An optional integer that sets the ending row index of the returned variable's integer/label pairs.}
}
\value{
A \code{data.table} with the variable's integer values and corresponding label strings.
}
\description{
For a Census Bureau categorical variable return a \code{data.table} with the
variable's integer values and corresponding label strings.

The function will attempt to locate a Bureau's categorical variable by name and
return a \code{data.table} with both the integer values and corresponding label strings. If
the variable is not located then NULL is returned.  Definitions for the variables were
obtained from
\href{https://www.census.gov/data/developers/data-sets/popest-popproj/popest/popest-vars.Vintage_2019.html}{Population Estimates Categorical Variables}
and other Bureau sources.
}
\examples{
library(data.table)
library(RcensusPkg)

# Get the names currently supported category variables
category_names_v <- RcensusPkg::get_category_strings(get_names = TRUE)

# Get the integer/string pairs for the category name "sex"
sex_category_dt <- RcensusPkg::get_category_strings(name = "sex")

}
