% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_metadata.R
\name{cdb_metadata}
\alias{cdb_metadata}
\title{Extract metadata from a COM(P)ADRE database}
\usage{
cdb_metadata(cdb)
}
\arguments{
\item{cdb}{A CompadreDB object}
}
\value{
Tibble with all metadata columns of \code{cdb}
}
\description{
Extract a tibble with only metadata information from a CompadreDB object, by
dropping the matrix column "mat".
}
\details{
Transforms the large CompadreDB object into a tibble and drops the
matrix column ("mat").
}
\examples{
Compadre_metadata <- cdb_metadata(Compadre)

}
\seealso{
Other data acquisition: 
\code{\link{cdb_build_cdb}()},
\code{\link{cdb_fetch}()}
}
\author{
Gesa Romer <gesa.roemer@gmail.com>
}
\concept{data acquisition}
