# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Logistic Regression Fitting Using L-BFGS Algorithm
#'
#' This function leverage \code{blaze} and \code{LBFGS-Blaze} to efficiently fit logistic regression.
#'
#' @param X The model matrix.
#' @param y The response vector.
#' @return A list of L-BFGS optimization result.
#'
#' @examples
#' X <- matrix(rnorm(5000), 1000)
#' coef <- runif(5, -3, 3)
#' y <- sapply(1 / (1 + exp(-X %*% coef)), function(p) rbinom(1, 1, p), USE.NAMES = FALSE)
#'
#' fit <- fastLogisticModel(X, y)
#' @export
fastLogisticModel <- function(X, y) {
    .Call(`_RcppLbfgsBlaze_fastLogisticModel`, X, y)
}

