% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb.R
\name{createCDB}
\alias{createCDB}
\title{Creates an environment containing CDB files}
\usage{
createCDB(
  SNOMED = getSNOMED(),
  TRANSITIVE = NULL,
  WN = NULL,
  MANUAL_SYNONYMS = NULL,
  noisy = TRUE,
  stopwords = c("the", "of", "by", "with", "to", "into", "and", "or", "at", "as",
    "and/or", "in")
)
}
\arguments{
\item{SNOMED}{environment containing a SNOMED dictionary}

\item{TRANSITIVE}{transitive closure table, generated by
createTransitive. It is regenerated if not provided.}

\item{WN}{WordNet data.table as returned by downloadWordnet
containing WordNet data from appropriate
categories, in the format: cat (character), wordnetId (integer64),
synonyms (list), parents (list), adj (list)}

\item{MANUAL_SYNONYMS}{data.table with columns term1 and term2,
containing additional exact synonyms or abbreviations}

\item{noisy}{whether to output status messages}

\item{stopwords}{vector of stopwords}
}
\value{
environment containing the following data tables: FINDINGS,
  QUAL, CAUSES, BODY, OTHERCAUSE, OTHERSEARCH, OVERLAP, TRANSITIVE
}
\description{
Extracts SNOMED CT concepts from appropriate places in the 
hierarchy to create a set of CDB files in an environment.
Uses WordNet and manual synonyms if available.
}
\examples{
# Not run
# data(MANUAL_SYNONYMS)
# WN <- downloadWordnet()
# MANUAL_SYNONYMS <- rbind(MANUAL_SYNONYMS, downloadOrphanet())
# CDBNEW <- createCDB(WN = WN, MANUAL_SYNONYMS = MANUAL_SYNONYMS)
}
\seealso{
exportMiADECDB, MANUAL_SYNONYMS

Other CDB functions: 
\code{\link{addComposeLookupToCDB}()},
\code{\link{addWordnet}()},
\code{\link{batchDecompose}()},
\code{\link{downloadOrphanet}()},
\code{\link{downloadWordnet}()}
}
\concept{CDB functions}
