% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimuData.R
\name{SimuData}
\alias{SimuData}
\title{Simulate two sequences of p-values by accounting for the local dependence structure via a hidden Markov model.}
\usage{
SimuData(
  J = 10000,
  pi = c(0.25, 0.25, 0.25, 0.25),
  A = 0.6 * diag(4) + 0.1,
  muA = 2,
  muB = 2,
  sdA = 1,
  sdB = 1
)
}
\arguments{
\item{J}{The number of features to be tested in two studies.}

\item{pi}{The stationary probabilities of four hidden joint states.}

\item{A}{The 4-by-4 transition matrix.}

\item{muA}{Mean of the normal distribution generating the p-value in study 1.}

\item{muB}{Mean of the normal distribution generating the p-value in study 2.}

\item{sdA}{The standard deviation of the normal distribution generating the p-value in study 1.}

\item{sdB}{The standard deviation of the normal distribution generating the p-value in study 2.}
}
\value{
A list:
\item{pa}{A numeric vector of p-values from study 1.}
\item{pb}{A numeric vector of p-values from study 2.}
\item{theta1}{The true states of features in study 1.}
\item{theta2}{The true states of features in study 2.}
}
\description{
Simulate two sequences of p-values by accounting for the local dependence structure via a hidden Markov model.
}
