% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EOFNH.R
\name{EOFNH}
\alias{EOFNH}
\title{The Extended Odd Frechet-Nadarjad-Hanhighi family}
\usage{
EOFNH(mu.link = "log", sigma.link = "log", nu.link = "log", tau.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}

\item{tau.link}{defines the tau.link, with "log" link as the default for the tau parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a EOFNH distribution in the \code{gamlss()} function.
}
\description{
The Extended Odd Frechet-Nadarjad-Hanhighi family
}
\details{
The Extended Odd Frechet-Nadarjad-Hanhighi  distribution with parameters \code{mu}, 
\code{sigma}, \code{nu} and \code{tau} has density given by

\eqn{f(x)= \frac{\mu\sigma\nu\tau(1+\nu x)^{\sigma-1}e^{(1-(1+\nu x)^\sigma)}[1-(1-e^{(1-(1+\nu x)^\sigma)})^{\mu}]^{\tau-1}}{(1-e^{(1-(1+\nu x)^{\sigma})})^{\mu\tau+1}} e^{-[(1-e^{(1-(1+\nu x)^\sigma)})^{-\mu}-1]^{\tau}},}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0}, \eqn{\nu > 0} and \eqn{\tau > 0}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma, nu and tau
y <- rEOFNH(n=100, mu=1, sigma=2.1, nu=0.8, tau=1)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, tau.fo=~1, family=EOFNH,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma, nu and tau
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))
exp(coef(mod, what='tau'))

# Example 2
# Generating random values under some model
n <- 200
x1 <- runif(n, min=0.4, max=0.6)
x2 <- runif(n, min=0.4, max=0.6)
mu <- exp(0.5 + x1)
sigma <- exp(0.8 + x2)
nu <- 1
tau <- 0.5
x <- rEOFNH(n=n, mu, sigma, nu, tau)

mod <- gamlss(x~x1, sigma.fo=~x2, nu.fo=~1, tau.fo=~1, family=EOFNH,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
exp(coef(mod, what="nu"))
exp(coef(mod, what="tau"))
}
\references{
\insertRef{nasiru2018extended}{RelDists}
}
\seealso{
\link{dEOFNH}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
