% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dPL.R
\name{dPL}
\alias{dPL}
\alias{pPL}
\alias{qPL}
\alias{rPL}
\alias{hPL}
\title{The Power Lindley distribution}
\usage{
dPL(x, mu, sigma, log = FALSE)

pPL(q, mu, sigma, lower.tail = TRUE, log.p = FALSE)

qPL(p, mu, sigma, lower.tail = TRUE, log.p = FALSE)

rPL(n, mu, sigma)

hPL(x, mu, sigma)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dPL} gives the density, \code{pPL} gives the distribution 
function, \code{qPL} gives the quantile function, \code{rPL}
generates random deviates and \code{hPL} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Power Lindley distribution 
with parameters \code{mu} and \code{sigma}.
}
\details{
The Power Lindley Distribution with parameters \code{mu} 
and \code{sigma} has density given by

\eqn{f(x) = \frac{\mu \sigma^2}{\sigma + 1} (1 + x^\mu) x ^ {\mu - 1} \exp({-\sigma x ^\mu}),}

for x > 0.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dPL(x, mu=1.5, sigma=0.2), from=0.1, to=10,
      col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pPL(x, mu=1.5, sigma=0.2),
      from=0.1, to=10, col="red", las=1, ylab="F(x)")
curve(pPL(x, mu=1.5, sigma=0.2, lower.tail=FALSE),
      from=0.1, to=10, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qPL(p, mu=1.5, sigma=0.2), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pPL(x, mu=1.5, sigma=0.2), from=0.1, add=TRUE, col="red")

## The random function
hist(rPL(n=1000, mu=1.5, sigma=0.2), freq=FALSE,
     xlab="x", las=1, main="")
curve(dPL(x, mu=1.5, sigma=0.2), from=0.1, to=15, add=TRUE, col="red")

## The Hazard function
par(mfrow=c(1,1))
curve(hPL(x, mu=1.5, sigma=0.2), from=0.1, to=15,
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{Ghitanya2013}{RelDists}
}
\author{
Amylkar Urrea Montoya, \email{amylkar.urrea@udea.edu.co}
}
