% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dWG.R
\name{dWG}
\alias{dWG}
\alias{pWG}
\alias{qWG}
\alias{rWG}
\alias{hWG}
\title{The Weibull Geometric distribution}
\usage{
dWG(x, mu, sigma, nu, log = FALSE)

pWG(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qWG(p, sigma, mu, nu, lower.tail = TRUE, log.p = FALSE)

rWG(n, mu, sigma, nu)

hWG(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{scale parameter.}

\item{sigma}{shape parameter.}

\item{nu}{parameter of geometric random variable.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dWG} gives the density, \code{pWG} gives the distribution 
function, \code{qWG} gives the quantile function, \code{rWG}
generates random deviates and \code{hWG} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the weibull geometric distribution with
parameters \code{mu}, \code{sigma} and \code{nu}.
}
\details{
The Weibull geometric distribution with parameters \code{mu},
\code{sigma} and \code{nu} has density given by

\eqn{f(x) = (\sigma \mu^\sigma (1-\nu) x^(\sigma - 1) \exp(-(\mu x)^\sigma)) 
(1- \nu \exp(-(\mu x)^\sigma))^{-2},}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0} and \eqn{0 < \nu < 1}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function 
curve(dWG(x, mu = 0.9, sigma = 2, nu = 0.5), from = 0, to = 3, 
ylim = c(0, 1.1), col = "red", las = 1, ylab = "f(x)")

## The cumulative distribution and the Reliability function
par(mfrow = c(1, 2))
curve(pWG(x, mu = 0.9, sigma = 2, nu = 0.5), from = 0, to = 3, 
ylim = c(0, 1), col = "red", las = 1, ylab = "F(x)")
curve(pWG(x, mu = 0.9, sigma = 2, nu = 0.5, lower.tail = FALSE), 
from = 0, to = 3, ylim = c(0, 1), col = "red", las = 1, ylab = "R(x)")

## The quantile function
p <- seq(from = 0, to = 0.99999, length.out = 100)
plot(x = qWG(p = p, mu = 0.9, sigma = 2, nu = 0.5), y = p, 
xlab = "Quantile", las = 1, ylab = "Probability")
curve(pWG(x,mu = 0.9, sigma = 2, nu = 0.5), from = 0, add = TRUE, 
col = "red")

## The random function
hist(rWG(1000, mu = 0.9, sigma = 2, nu = 0.5), freq = FALSE, xlab = "x", 
ylim = c(0, 1.8), las = 1, main = "")
curve(dWG(x, mu = 0.9, sigma = 2, nu = 0.5),  from = 0, add = TRUE, 
col = "red", ylim = c(0, 1.8))

## The Hazard function(
par(mfrow=c(1,1))
curve(hWG(x, mu = 0.9, sigma = 2, nu = 0.5), from = 0, to = 8, 
ylim = c(0, 12), col = "red", ylab = "Hazard function", las = 1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{barreto2011weibull}{RelDists}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
