% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myOW_region.R
\name{myOW_region}
\alias{myOW_region}
\title{Custimized region search for odd Weibull distribution}
\usage{
myOW_region(family = OW, valid.values = "auto", initVal)
}
\arguments{
\item{family}{The \code{\link{OW}} family. This arguments allows the user to
modify input arguments of the family, like the \code{link}
functions.}

\item{valid.values}{a list of character elements specifying the region for 
\code{sigma} and/or \code{nu}. See \strong{Details} and \strong{Examples}
section to learn about its use.}

\item{initVal}{An \code{initValOW} object generated with \code{\link{initValuesOW}}
function.}
}
\value{
Returns a \code{gamlss.family} object which can be used to fit an OW 
distribution in the \code{gamlss()} function.
}
\description{
This function can be used to modify \code{OW} \code{gamlss.family} object 
in order to  set a customized region search for \code{gamlss()} function.
}
\details{
This function was created to help users to fit \code{OW} distribution easily 
bounding the parametric space for \code{sigma} and \code{nu}.

The \code{valid.values} must be defined as a list of characters containing a call
of the \code{\link{all}} function.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma and nu
y <- rOW(n=200, mu=0.2, sigma=4, nu=0.05)

# Custom search region
myvalues <- list(sigma="all(sigma > 1)",
                 nu="all(nu < 1) & all(nu < 1)")

my_initial_guess <- initValuesOW(formula=y~1)
summary(my_initial_guess)

# OW family modified with 'myOW_region'
require(gamlss)
myOW <- myOW_region(valid.values=myvalues, initVal=my_initial_guess)
mod1 <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, 
               sigma.start=param.startOW('sigma', my_initial_guess), 
               nu.start=param.startOW('nu', my_initial_guess),
               control=gamlss.control(n.cyc=300, trace=FALSE),
               family=myOW)

exp(coef(mod1, what='mu'))
exp(coef(mod1, what='sigma'))
exp(coef(mod1, what='nu'))

# Example 2
# Same example using another link function and using 'myOW_region'
# in the argument 'family'
mod2 <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, 
               sigma.start=2, nu.start=0.1,
               control=gamlss.control(n.cyc=300, trace=FALSE),
               family=myOW_region(family=OW(sigma.link='identity'),
                                  valid.values=myvalues,
                                  initVal=my_initial_guess))

exp(coef(mod2, what='mu'))
coef(mod2, what='sigma')
exp(coef(mod2, what='nu'))
}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
