set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10))
distance=RelativeDistance
centers_function<-centers_function_RelativeDistance
init_centers=init_centers_random



RES=Hartigan_and_Wong_total(data, distance,centers_function,init_centers,  seed=10, ITER=10,KK=4, index="DaviesBouldin", k=NULL)

o2=Hartigan_and_Wong(data, distance,4,centers_function,init_centers, seed=10, 10)


RES2=Hartigan_and_Wong_total(data, distance,centers_function,init_centers,seed=10, ITER=10,  k=4)

#We make sure they are the same
test_that("Hartigan_and_Wong_total", {
  expect_equal(RES$Output_of_grouping$centers, RES$Output_of_grouping$centers)
  expect_equal(RES$Output_of_grouping$grouping, o2$grouping,tolerance=1e-6)
  expect_equal(length(RES$Quality), 5,tolerance=1e-6)
  expect_equal(RES2$Output_of_grouping$centers, o2$centers)
  expect_equal(RES2$Output_of_grouping$grouping, o2$grouping,tolerance=1e-6)


})
