set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5
distance=RelativeDistance
centers_function<-centers_function_RelativeDistance
init_centers=init_centers_random


o2=NEC(data, distance,k,centers_function,init_centers, seed=seed, 10, 0.01)

#We make sure they are the same
test_that("NEC", {
  expect_equal(all(o2$FHW_output$centers %in% data), TRUE)
  expect_equal(dim(o2$FHW_output$centers)[1],  k,tolerance=1e-6)
  expect_equal(dim(o2$FHW_output$centers)[2], dim(data)[2],tolerance=1e-6)
  expect_equal(length(o2$FHW_output$grouping),  k,tolerance=1e-6)
})


#The results of NEC, kmeans and Hartigan_and_Wong do not have to be equal but
#we test if there are cases where the results are equal.
#In  simple situations, all methods should be able to achieve the same result.

############
#Test con la euclidea (init hw)
############

set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5
distance=Euclideandistance
centers_function<-centers_function_mean
init_centers=init_centers_hw

#with kmeans
if(!is.null(seed)){
  set.seed(seed)
}
centers <- data[sample(1:nrow(data), k), ]
kmeas_R=kmeans(data,centers, 10,algorithm ="Hartigan-Wong")
dimnames(kmeas_R$centers) <- NULL

e1=Hartigan_and_Wong(data, distance,k,centers_function,init_centers,seed=seed, 10)
e2=NEC(data, distance,k,centers_function,init_centers, seed=seed, 10, 0.01)

grouping_orderd=list(e2$FHW_output$grouping[[2]], e2$FHW_output$grouping[[3]],e2$FHW_output$grouping[[1]])
centers_orderd=rbind(e2$FHW_output$centers[2,],e2$FHW_output$centers[3,],e2$FHW_output$centers[1,])

vector=c()
for (ii in 1:dim(data)[1]){
  vector[ii]=encontrar_componente(grouping_orderd, ii)
}


#We make sure they are the same
test_that("NEC", {
  expect_equal(centers_orderd,  kmeas_R$centers,tolerance=1e-6)
  expect_equal(vector, kmeas_R$cluster,tolerance=1e-6)
  expect_equal(e2$FHW_output$centers,  e1$centers,tolerance=1e-6)
  expect_equal(e2$FHW_output$grouping, e2$FHW_output$grouping,tolerance=1e-6)
})


############
#Test de la distancia RelativeDistance (init random)
############
set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5
distance=RelativeDistance
centers_function<-centers_function_RelativeDistance
init_centers=init_centers_random



o1=Hartigan_and_Wong(data, distance,k,centers_function,init_centers,seed=seed, 10)
o2=NEC(data, distance,k,centers_function,init_centers, seed=seed, 10, 0.01)

#We make sure they are the same
test_that("NEC", {
  expect_equal(o2$FHW_output$centers,  o1$centers,tolerance=1e-6)
  expect_equal(o2$FHW_output$grouping, o1$grouping,tolerance=1e-6)
})


############
#Test de la distancia RelativeDistance(init hw)
############
set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),matrix(runif(20,20,30), nrow = 2, ncol = 10),matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5
distance=RelativeDistance
centers_function<-centers_function_RelativeDistance
init_centers=init_centers_hw



o1=Hartigan_and_Wong(data, distance,k,centers_function,init_centers,seed=seed, 10)
o2=NEC(data, distance,k,centers_function,init_centers, seed=seed, 10, 0.01)

#We make sure they are the same
test_that("NEC", {
  expect_equal(o2$FHW_output$centers,  o1$centers,tolerance=1e-6)
  expect_equal(o2$FHW_output$grouping, o1$grouping,tolerance=1e-6)
})



