% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPopSizes.R
\name{plotPopSizes}
\alias{plotPopSizes}
\title{Plot Population Sizes}
\usage{
plotPopSizes(
  df,
  plot_CIs = TRUE,
  add = FALSE,
  existing_plot = NULL,
  col = "#00883a"
)
}
\arguments{
\item{df}{(data frame) such as produced by processPopSizes(), containing
the data on population sizes and corresponding grid points (points in time for population size evaluation)}

\item{plot_CIs}{(boolean; default: TRUE) specifies whether the credible intervals should be plotted.}

\item{add}{(boolean; default: FALSE) specifies whether the new plot should be added to an existing ggplot2 object. If TRUE,
the existing_plot has to be given.}

\item{existing_plot}{(ggplot2 object; default: NULL) a ggplot2 object to which the new plot should be added.}

\item{col}{(string; default: "#00883a") color for the trajectories}
}
\value{
a ggplot object
}
\description{
Plots the output of a coalescent demographic analysis.
}
\details{
Plots the output of coalescent demographic analyses. Takes as
input the output of processPopSizes() and plotting parameters.

The return object can be manipulated. For example, you can change the
axis labels, the color palette, whether the axes are to be linked, or the
overall plotting style/theme, just as with any ggplot object.
}
\examples{
df <- dplyr::tibble("time" = c(0.0, 1.0, 2.0, 3.0, 4.0),
                    "value" = c(1.0, 1.5, 2.0, 1.5, 1.5),
                    "upper" = c(3.5, 7.0, 6.5, 5.0, 5.0),
                    "lower" = c(0.5, 0.1, 0.5, 0.5, 0.8))

plotPopSizes(df)

}
