% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbOAuth.R
\name{fbOAuth}
\alias{fbOAuth}
\title{Create OAuth token to Facebook R session}
\usage{
fbOAuth(app_id, app_secret, extended_permissions = FALSE,
  legacy_permissions = FALSE, scope = NULL)
}
\arguments{
\item{app_id}{numeric, App ID of application to be used to create OAUth token. Available
at \url{https://developers.facebook.com/apps}}

\item{app_secret}{string, App Secret of application to be used to create OAUth token.
Available at \url{https://developers.facebook.com/apps}, in Basic Settings panel.}

\item{extended_permissions}{If \code{TRUE}, the token will give access to some of
the authenticated user's private information (birthday, hometown, location,
relationships) and that of his/her friends, and permissions to post
status updates as well as to access checkins, likes, and the user's newsfeed
If \code{FALSE}, token will give access only to public information. Note 
that \code{updateStatus} will only work for tokens with extended permissions.
After version 2.0 of the Graph API, creating an application with these permissions
requires passing App Review (\url{https://developers.facebook.com/docs/facebook-login/review})}

\item{legacy_permissions}{For tokens created with old versions of the API, this option
adds the "read_stream" permission}

\item{scope}{Specify an explicit lists of permissions to ask (overrides extended_permissions)}
}
\description{
\code{fbOAuth} creates a long-lived OAuth access token that enables R to make
authenticated calls to the Facebook API. The token can be saved as a
file in disk to be re-used in future sessions. This function relies on the
\code{httr} package to create the OAuth token, and is a simplified version
of one of its examples.

This function will automatically detect the API version for the token you create.
}
\details{
There are two different ways of making authenticated requests. One is to obtain
a temporary access token from \url{https://developers.facebook.com/tools/explorer/},
which can be used as argument in any of the functions in Rfacebook. An example is 
shown below.

However, this token has a 2-hour lifetime by default and after it expires, it
needs to be renewed. The second alternative is to create an OAuth token. The 
process to create it is a bit more tedious. It is divided in three steps.

First, go to \url{https://developers.facebook.com/apps}, register as a developer
and create a new app. You will also need a verified Facebook account.
After that, click in "Show" under "App Secret" to find your 'App ID' and 'App Secret'.

Second, run the \code{fbOAuth} function with your "App ID" and "App Secret" as 
arguments. It will return a URL, which you will need to paste into the "Website with
Facebook login" field in your App Settings on Facebook. Once you've done so, press Enter.

Third, after pressing Enter, R will try to open a browser window to sign the token. If 
everything works well, you will get a message that says you can return to R. If not,
try again in a few minutes to make sure your app had its settings updated properly.

To ensure proper functioning of the "getInsights" function-family you will need to 
specify the exact permissions granted to your app. As this is (to our knowledge) currently not
possible through the R based authentication process, please follow these steps:

-> Create App as mentioned above.
1. Open the "Graph API Explorer": \url{https://developers.facebook.com/tools/explorer/}
2. Select your app in the upper right corner
3. Click "Get Token" -> "Get Access Token"
4. In the popup navigate to "Extended Permissions" and select "Insights"
5. Confirm
6. Ignore the following warning message ("Submit for Login Review...") and confirm again.
6. Go back to R and run fbOAuth with extended_permissions (still) set to FALSE. 
-> See third step for possible messages concerning token creation.
}
\examples{
\dontrun{
## an example of an authenticated request after creating the OAuth token
## where app_id and app_secret are fictitious, and token is saved for
## future sessions
fb_oauth <- fbOAuth(app_id="123456789", app_secret="1A2B3C4D")
save(fb_oauth, file="fb_oauth")
load("fb_oauth")
me <- getUsers("me", token=fb_oauth)
me$username

## an example of a request using a temporary access token
	token <- "XXXXXXAAAAAAA1111"
	me <- getUsers("me", token=token)
}

}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{getUsers}}, \code{\link{getPost}}, \code{\link{searchFacebook}}
}

