% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGroup.R
\name{searchGroup}
\alias{searchGroup}
\title{Find Facebook ID of a group}
\usage{
searchGroup(name, token, api = NULL)
}
\arguments{
\item{name}{Name of Facebook group (in URL)}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{api}{API version. e.g. "v2.8". \code{NULL} is the default.}
}
\description{
Use \code{searchGroup} in combination with \code{getGroup} to scrape
public posts on Facebook groups.
}
\examples{
\dontrun{
## Find Facebook ID for R-Users Facebook group
load("fb_oauth")
ids <- searchGroup(name="rusers", token=fb_oauth)
 ids[1,] # id = 18533493739
## Downloading posts from R-Users Facebook group
 group <- getGroup(group_id=18533493739, token=fb_oauth)
## Downloading posts from R-Users Facebook group in January 2013
 group <- getGroup(group_id=18533493739, token=fb_oauth,
	since='2013/01/01', until='2013/01/31')
}
}

