% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgff.R
\name{sort_gff}
\alias{sort_gff}
\title{Sorts a GTF/GFF3 file}
\usage{
sort_gff(
  inFile,
  outFile,
  fileType = c("AUTO", "GFF3", "GTF"),
  forceOverwrite = FALSE
)
}
\arguments{
\item{inFile}{Path to the input GFF file}

\item{outFile}{Path to the output sorted file, if not provided the output will be the input path (without extension) with the suffix sorted.gtf/gff3}

\item{fileType}{Version of the input file (GTF/GFF3). Default AUTO: determined from the file name.}

\item{forceOverwrite}{If output file exists, overwrite the existing file. (default FALSE)}
}
\value{
Path to the sorted feature file
}
\description{
This function produces a sorted GFF file from an unsorted GFF file.
The default order is by Chromosome, Start, End (reverse) and feature (based on the precedency in feature tree)
}
\examples{
test_gff3<-system.file("extdata", "eden.gff3", package="Rgff")
sort_gff(test_gff3)
}
