% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_orbital.R
\docType{data}
\name{orbital}
\alias{orbital}
\title{Data : Normal Vectors to the Orbital Planes of the 9 Planets}
\format{
an \eqn{(9\times 3)} matrix where each row is a normal vector for a planet.
}
\usage{
data(orbital)
}
\description{
The 9 planets in our solar system are evolving the sun via their own orbits. 
This data provides normal vector of the orbital planes. Normal vectors are 
unit-norm vectors, so that they are thought to reside on 2-dimensional sphere.
}
\examples{
## LOAD THE DATA AND WRAP AS RIEMOBJ
data(orbital)
myorb = wrap.sphere(orbital)

## VISUALIZE
mds2d = riem.mds(myorb)$embed
opar <- par(no.readonly=TRUE)
plot(mds2d, main="9 Planets", pch=19, xlab="x", ylab="y")
par(opar)

}
\seealso{
\code{\link{wrap.sphere}}
}
\concept{data}
\keyword{datasets}
