% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_sphere.R
\name{sphere.runif}
\alias{sphere.runif}
\title{Generate Uniform Samples on Sphere}
\usage{
sphere.runif(n, p, type = c("list", "matrix", "riemdata"))
}
\arguments{
\item{n}{number of samples to be generated.}

\item{p}{original dimension (of the ambient space).}

\item{type}{return type; \describe{
\item{\code{"list"}}{a length-\eqn{n} list of length-\eqn{p} vectors.}
\item{\code{"matrix"}}{a \eqn{(n\times p)} where rows are unit vectors.}
\item{\code{"riemdata"}}{a S3 object. See \code{\link{wrap.sphere}} for more details (\emph{Default}).}
}}
}
\value{
an object from one of the above by \code{type} option.
}
\description{
It generates \eqn{n} random samples from \eqn{\mathcal{S}^{p-1}}. For convenient 
usage of users, we provide a number of options in terms of the return type.
}
\examples{
#-------------------------------------------------------------------
#                       Draw Samples on Sphere
#
# Multiple return types on S^4 in R^5
#-------------------------------------------------------------------
dat.list = sphere.runif(n=10, p=5, type="list")
dat.matx = sphere.runif(n=10, p=5, type="matrix")
dat.riem = sphere.runif(n=10, p=5, type="riemdata")

}
\references{
\insertRef{chikuse_statistics_2003}{Riemann}
}
\seealso{
\code{\link{wrap.sphere}}
}
\concept{sphere}
