% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IEX_Market_Data.R
\name{financials}
\alias{financials}
\alias{iex.cash.flow}
\alias{iex.balance.sheet}
\alias{iex.income}
\title{`IEX` financials}
\usage{
iex.cash.flow(x, iex_sk)

iex.balance.sheet(x, iex_sk)

iex.income(x, iex_sk)
}
\arguments{
\item{x}{A character vector that can include one or multiple  Tickers / Stocks Symbols}

\item{iex_sk}{is a character vector that include IEX Cloud API Secret Token}
}
\value{
Data frame with stock(s) financial data with option of selecting quarterly or annually
}
\description{
Returns income statement, balance sheet, and cash flow data from the most recent reported quarter.
For more details, visit:\url{https://iexcloud.io/docs/api/#financials}
}
\examples{
\dontrun{
  iex.cash.flow("TSLA", "sk")
 }
}
\seealso{
Investors Exchange `IEX` developer guide \url{https://iexcloud.io/docs/api/}

Investors Exchange Group (IEX Group) offers flexible and salable pricing.\url{https://iexcloud.io/pricing/}

View Investors Exchange Group (IEX Group) terms of use and subscription levels.\url{https://iexcloud.io/terms/}

Package `iexcloudR`\url{https://github.com/schardtbc/iexcloudR}
}
\author{
Myriam Ibrahim
}
