% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_grm.R
\name{model_grm}
\alias{model_grm}
\alias{model_grm_prob}
\alias{model_grm_info}
\alias{model_grm_lh}
\alias{model_grm_gendata}
\alias{model_grm_rescale}
\alias{model_grm_plot}
\alias{model_grm_plot_loglh}
\title{Graded Response Model}
\usage{
model_grm_prob(t, a, b, D = 1.702, raw = FALSE)

model_grm_info(t, a, b, D = 1.702)

model_grm_lh(u, t, a, b, D = 1.702, log = FALSE)

model_grm_gendata(n_p, n_i, n_c, t = NULL, a = NULL, b = NULL,
  D = 1.702, t_dist = c(0, 1), a_dist = c(-0.1, 0.2), b_dist = c(0,
  0.8), t_bounds = c(-3, 3), a_bounds = c(0.01, 2.5),
  b_bounds = c(-3, 3), missing = NULL, ...)

model_grm_rescale(t, a, b, scale = c("t", "b"), mean = 0, sd = 1)

model_grm_plot(a, b, D = 1.702, type = c("prob", "info"),
  item_level = FALSE, total = FALSE, xaxis = seq(-6, 6, 0.1),
  raw = FALSE)

model_grm_plot_loglh(u, a, b, D = 1.702, xaxis = seq(-6, 6, 0.1),
  verbose = FALSE)
}
\arguments{
\item{t}{ability parameters, 1d vector}

\item{a}{discrimination parameters, 1d vector}

\item{b}{item location parameters, 2d matrix}

\item{D}{the scaling constant, default=1.702}

\item{raw}{TRUE to return P*}

\item{u}{observed scores (starting from 0), 2d matrix}

\item{log}{TRUE to return log-likelihood}

\item{n_p}{the number of people to be generated}

\item{n_i}{the number of items to be generated}

\item{n_c}{the number of score categories}

\item{t_dist}{parameters of the normal distribution used to generate t-parameters}

\item{a_dist}{parameters of the lognormal distribution used to generate a-parameters}

\item{b_dist}{parameters of the normal distribution used to generate b-parameters}

\item{t_bounds}{the bounds of the ability parameters}

\item{a_bounds}{the bounds of the discrimination parameters}

\item{b_bounds}{the bounds of the difficulty parameters}

\item{missing}{the proportion or number of missing responses}

\item{...}{additional arguments}

\item{scale}{the scale, 't' for theta or 'b' for b-parameters}

\item{mean}{the mean of the new scale}

\item{sd}{the standard deviation of the new scale}

\item{type}{the type of plot, prob for ICC and info for IIFC}

\item{item_level}{TRUE to combine categories}

\item{total}{TRUE to sum values over items}

\item{xaxis}{the values of x-axis}

\item{verbose}{TRUE to print rough maximum likelihood values}
}
\value{
\code{model_grm_prob} returns the resulting probabilities in a 3d array

\code{model_grm_info} returns the resulting information in a 3d array

\code{model_grm_lh} returns the resulting likelihood in a matrix

\code{model_grm_gendata} returns the generated response data and parameters in a list

\code{model_grm_rescale} returns t, a, b parameters on the new scale

\code{model_grm_plot} returns a \code{ggplot} object

\code{model_grm_plot_loglh} returns a \code{ggplot} object
}
\description{
Common computations and operations for the GRM
}
\examples{
with(model_grm_gendata(10, 5, 3), model_grm_prob(t, a, b))
with(model_grm_gendata(10, 5, 3), model_grm_info(t, a, b))
with(model_grm_gendata(10, 5, 3), model_grm_lh(u, t, a, b))
model_grm_gendata(10, 5, 3)
model_grm_gendata(10, 5, 3, missing=.1)
with(model_grm_gendata(10, 5, 3), model_grm_plot(a, b, type='prob'))
with(model_grm_gendata(10, 5, 3), model_grm_plot(a, b, type='info', item_level=TRUE))
with(model_grm_gendata(5, 50, 3), model_grm_plot_loglh(u, a, b))
}
