% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{Bm}
\alias{Bm}
\title{Simulation of Brownian motion}
\usage{
Bm(x_start = 0, t_start = 0, t_end = 1, N = 1000, plot = FALSE)
}
\arguments{
\item{x_start}{Value of the process at the initial time point (additive constant mean).}

\item{t_start}{Initial time point.}

\item{t_end}{Terminal time point.}

\item{N}{Number of time steps on the interval \code{[t_start,t_end]}.
Default set to 1000.}

\item{plot}{Logical: If \code{TRUE}, the realisation of the Brownian
motion is plotted in interactive sessions.}
}
\value{
A data frame where the first column is \code{t} and second
column is simulated values of the realisation of Brownian motion with added constant mean.
}
\description{
This function simulates a realisation of the Brownian motion over the
time interval \code{[t_start,t_end]} with \code{N} time steps and initial value \code{x_start}.
}
\examples{
Bm(t_end = 2, plot = TRUE)
}
\seealso{
\code{\link{GHBMP}}, \code{\link{FBm}}, \code{\link{FGn}}, \code{\link{Bbridge}}, \code{\link{FBbridge}}
}
