% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analyses_functions_2.R
\name{long_streak}
\alias{long_streak}
\title{Longest increasing/decreasing streak}
\usage{
long_streak(X, direction = "increasing", subI = NULL, plot = FALSE)
}
\arguments{
\item{X}{Data frame where the first column is a numeric time sequence \eqn{t}
and the second one is the values of the time series \eqn{X(t)}.}

\item{direction}{A character string which specifies the direction of
the streak: \code{"increasing"} or \code{"decreasing"}.}

\item{subI}{Time sub-interval is a vector, where the lower bound is
the first element and the upper bound is the second. Optional: If provided
longest streak(s) time span of the sub-interval is returned, otherwise the whole time interval is considered.}

\item{plot}{Logical: If \code{TRUE}, the time series and the longest streaks(s) of
increasing/decreasing is plotted in interactive sessions.}
}
\value{
A data frame with one row for each longest streak, containing the time span
and the corresponding values of \eqn{X(t)} at the streak endpoints.
}
\description{
Computes the time span of the longest increasing or decreasing streak(s)
of a time series for the provided time interval or its sub-interval.
}
\examples{
t <- seq(0, 1, length = 100)
TS <- data.frame("t" = t,"X(t)" = rnorm(100))
long_streak(TS, direction = 'decreasing', subI = c(0.2, 0.8), plot = TRUE)
}
\seealso{
\code{\link{mean_streak}}
}
