% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fareg.R
\name{fareg}
\alias{fareg}
\title{Regularized Factor Analysis}
\usage{
fareg(R, numFactors = 1, facMethod = "rls")
}
\arguments{
\item{R}{(Matrix) A correlation matrix to be analyzed.}

\item{numFactors}{(Integer) The number of factors to extract. Default: numFactors = 1.}

\item{facMethod}{(Character) "rls" for regularized least squares estimation or 
"rml" for regularized maximum likelihood estimation. Default: facMethod = "rls".}
}
\value{
The main output is the matrix of unrotated factor loadings.
\itemize{
  \item \strong{loadings}: (Matrix) A matrix of unrotated factor loadings.
  \item \strong{h2}: (Vector) A vector of estimated communality values.
  \item \strong{L}: (Numeric) Value of the estimated penality parameter.
  \item \strong{Heywood} (Logical) TRUE if a Heywood case is detected 
               (this should never happen).
  }
}
\description{
This function applies the regularized factoring method to extract an unrotated factor structure matrix.
}
\note{
This function is from the \code{fungible} package of Niels Waller which has been archived december 19th 2025 (CRAN team, personal communication). The relevant function are \code{fareg} and \code{rmsd}. The documentation is from the original function.
}
\examples{
 # Conduct a regularized factor analysis
regOut <- fareg(R = ex_2factors, 
               numFactors = 2,
               facMethod = "rls")
regOut$L
regOut$Heywood
}
\references{
Jung, S. & Takane, Y.  (2008).  Regularized common factor analysis. New trends in psychometrics, 141-149.  
Waller, N. G. (2024). \code{fungible}: Psychometric Functions from the Waller Lab. University of Minnesota, Minneapolis, Minnesota. R package 2.4.4, <https://CRAN.R-project.org/package=fungible>.
}
\author{
Niels G. Waller (nwaller@umn.edu)
}
\concept{Factor Analysis Routines}
