% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nightly.R
\name{nightly}
\alias{nightly}
\title{Implement a dark/light toggle mode by default}
\usage{
nightly(
  trigElement,
  bodyColor = "#282828",
  txtColor = "#f5f5f5",
  inpTxtColor = "#f5f5f5",
  inpBgColor = "#313131"
)
}
\arguments{
\item{trigElement}{the id of the shiny element that will trigger the toggle mode}

\item{bodyColor}{the color of the application's body after clicking on the trigElement. Defaults to #282828 (dark)}

\item{txtColor}{the color of the text within the application after clicking on the trigElement. Defaults to #f5f5f5 (white)}

\item{inpTxtColor}{the color of the text within the shiny inputs after clicking on the trigElement. Defaults to #f5f5f5 (white)}

\item{inpBgColor}{the color of the background of the shiny inputs after clicking on the trigElement. Defaults to #313131 (Very Dark Grey)}
}
\value{
A default dark/light toggle mode in shiny ui
}
\description{
Implement a default dark/light toggle mode that will be triggered by any shiny element. The user can also define other colors to work with.
}
\examples{
if (interactive()) {
ui <- fluidPage(
 use_nightly(),

 h1("Click on the Plot to Toggle a Dark/Light Mode in you Shiny Application"),

 plotOutput(outputId = "plt1"),

 nightly(trigElement = "plt1")

)


server <- function(input, output) {

output$plt1 <- renderPlot({


plot(mtcars)


})


}


shinyApp(ui = ui, server = server)


}



}
